from header_factions import *

####################################################################################################################
#  Each faction record contains the following fields:
#  1) Faction id: used for referencing factions in other files.
#     The prefix fac_ is automatically added before each faction id.
#  2) Faction name.
#  3) Faction flags. See header_factions.py for a list of available flags
#  4) Faction coherence. Relation between members of this faction.
#  5) Relations. This is a list of relation records.
#     Each relation record is a tuple that contains the following fields:
#    5.1) Faction. Which other faction this relation is referring to
#    5.2) Value: Relation value between the two factions.
#         Values range between -1 and 1.
#  6) Ranks
#  7) Faction color (default is gray)
####################################################################################################################

default_kingdom_relations = [("outlaws",-0.05),("peasant_rebels", -0.1),("deserters", -0.02),("dark_knights", -0.04),("black_khergits", -0.04)] ## CC

factions = [
  ("no_faction","No Faction",0, 0.9, [], []),
  ("commoners","Commoners",0, 0.1,[("player_faction",0.1)], []),
  ("outlaws","Outlaws", max_player_rating(-30), 0.5,[("commoners",-0.6),("player_faction",-0.15),("kingdom_1",-0.15),("kingdom_2",-0.15),("kingdom_3",-0.15),("kingdom_4",-0.15),("kingdom_5",-0.15),("kingdom_6",-0.15)], [], 0xEE7744), ## CC
# Factions before this point are hardwired into the game end their order should not be changed.

  ("neutral","Neutral",0, 0.1,[("player_faction",0.0)], [],0xFFFFFF),
  ("innocents","Innocents", ff_always_hide_label, 0.5,[("outlaws",-0.05)], []),
  ("merchants","Merchants", ff_always_hide_label, 0.5,[("outlaws",-0.5),], []),

## CC
  ("dark_knights","{!}Dark Knights", 0, 0.5,[("player_faction",-0.4),("player_supporters_faction",-0.4),("outlaws", 0.1)], [], 0x800000),
  ("black_khergits","{!}Black Khergits", 0, 0.5,[("player_faction",-0.4),("player_supporters_faction",-0.4),("outlaws", 0.1)], [], 0x800000),
## CC

  ("culture_1",  "{!}culture_1", 0, 0.9, [], []),
  ("culture_2",  "{!}culture_2", 0, 0.9, [], []),
  ("culture_3",  "{!}culture_3", 0, 0.9, [], []),
  ("culture_4",  "{!}culture_4", 0, 0.9, [], []),
  ("culture_5",  "{!}culture_5", 0, 0.9, [], []),
  ("culture_6",  "{!}culture_6", 0, 0.9, [], []),
  ("culture_7",  "{!}culture_7", 0, 0.9, [], []), ## NMC

#  ("swadian_caravans","Swadian Caravans", 0, 0.5,[("outlaws",-0.8), ("dark_knights",-0.2)], []),
#  ("vaegir_caravans","Vaegir Caravans", 0, 0.5,[("outlaws",-0.8), ("dark_knights",-0.2)], []),

  ("player_faction","Player Faction",0, 0.9, [], []),
## CC
  ("player_supporters_faction","Teutonic Knights",0, 0.9, [("player_faction",1.00),("outlaws",-0.05),("peasant_rebels", -0.1),("deserters", -0.02)], [], 0xFFFFFF), #changed name so that can tell difference if shows up on map
  ("kingdom_1",  "Kingdom of Jerusalem",   0, 0.9, [("kingdom_2",1.00),("kingdom_3",-1.00),("kingdom_4",1.00),("kingdom_5",1.00),("kingdom_6",-1.00)], [], 0x66CCFF),
  ("kingdom_2",  "Principality of Antioch",  0, 0.9, [("kingdom_1",1.00),("kingdom_3",-1.00),("kingdom_4",1.00),("kingdom_5",1.00),("kingdom_6",-1.00)], [], 0x3333FF),
  ("kingdom_3",  "Sultanate of Rum",     0, 0.9, [("kingdom_1",-1.00),("kingdom_2",-1.00),("kingdom_4",-1.00),("kingdom_5",-1.00),("kingdom_6",1.00)], [], 0x999900),
  ("kingdom_4",  "Knights Templar",    0, 0.9, [("kingdom_1",1.00),("kingdom_2",1.00),("kingdom_3",-1.00),("kingdom_5",1.00),("kingdom_6",-1.00)], [], 0xFF0000),
  ("kingdom_5",  "Knights Hospitaller",  0, 0.9, [("kingdom_1",1.00),("kingdom_2",1.00),("kingdom_3",-1.00),("kingdom_4",1.00),("kingdom_6",-1.00)], [], 0x9900FF),
  ("kingdom_6",  "Ayyubid Sultanate",  0, 0.9, [("kingdom_1",-1.00),("kingdom_2",-1.00),("kingdom_3",1.00),("kingdom_4",-1.00),("kingdom_5",-1.00)], [], 0x006600),
## CC

##  ("kingdom_1_rebels",  "Swadian rebels", 0, 0.9, [("outlaws",-0.05),("peasant_rebels", -0.1),("deserters", -0.02),("mountain_bandits", -0.05),("forest_bandits", -0.05)], [], 0xCC2211),
##  ("kingdom_2_rebels",  "Vaegir rebels",    0, 0.9, [("outlaws",-0.05),("peasant_rebels", -0.1),("deserters", -0.02),("mountain_bandits", -0.05),("forest_bandits", -0.05)], [], 0xCC2211),
##  ("kingdom_3_rebels",  "Khergit rebels", 0, 0.9, [("outlaws",-0.05),("peasant_rebels", -0.1),("deserters", -0.02),("mountain_bandits", -0.05),("forest_bandits", -0.05)], [], 0xCC2211),
##  ("kingdom_4_rebels",  "Nord rebels",    0, 0.9, [("outlaws",-0.05),("peasant_rebels", -0.1),("deserters", -0.02),("mountain_bandits", -0.05),("forest_bandits", -0.05)], [], 0xCC2211),
##  ("kingdom_5_rebels",  "Rhodok rebels",  0, 0.9, [("outlaws",-0.05),("peasant_rebels", -0.1),("deserters", -0.02),("mountain_bandits", -0.05),("forest_bandits", -0.05)], [], 0xCC2211),

  ("kingdoms_end","{!}kingdoms_end", 0, 0,[], []),
  ("robber_knights",  "{!}robber_knights", 0, 0.1, [], []),
  ("khergits","{!}Khergits", 0, 0.5,[("player_faction",0.0)], []),
##  ("rebel_peasants","Rebel Peasants", 0, 0.5,[("vaegirs",-0.5),("player_faction",0.0)], []),

## CC
  ("manhunters","Turcopoles", 0, 0.5,[("outlaws",-0.6),("player_faction",0.1)], [], 0x80ff80),
  ("deserters","Deserters", 0, 0.5,[("manhunters",-0.6),("merchants",-0.5),("player_faction",-0.1),("kingdom_1",-0.2),("kingdom_2",-0.2),("kingdom_3",-0.2),("kingdom_4",-0.2),("kingdom_5",-0.2),("kingdom_6",-0.2)], [], 0xff8080),
  #("mountain_bandits","Mountain Bandits", 0, 0.5,[("commoners",-0.2),("merchants",-0.5),("manhunters",-0.6),("player_faction",-0.15)], [], 0x888888),
  #("forest_bandits","Forest Bandits", 0, 0.5,[("commoners",-0.2),("merchants",-0.5),("manhunters",-0.6),("player_faction",-0.15)], [], 0x888888),
## CC

  ("undeads","{!}Undeads", max_player_rating(-30), 0.5,[("commoners",-0.7),("player_faction",-0.5)], []),
  ("slavers","{!}Slavers", 0, 0.1, [], []),
  ("peasant_rebels","{!}Peasant Rebels", 0, 1.0,[("noble_refugees",-1.0),("player_faction",-0.4)], []),
  ("noble_refugees","{!}Noble Refugees", 0, 0.5,[], []),
]

##diplomacy start+ Define these for convenience
dplmc_factions_begin = 1 #As mentioned in the notes above, this is hardcoded and shouldn't be altered.  Deliberately excludes "no faction".
dplmc_non_generic_factions_begin = [x[0] for x in enumerate(factions) if x[1][0] == "merchants"][0] + 1
dplmc_factions_end   = len(factions)
##diplomacy end+
# modmerger_start version=201 type=4
try:
    component_name = "factions"
    var_set = { "factions":factions,"default_kingdom_relations":default_kingdom_relations, }
    from modmerger import modmerge
    modmerge(var_set, component_name)
except:
    raise
# modmerger_end
